<?php defined('SYSPATH') or die('No direct script access.');

class Helper{

    public static function isJson($str) {
        if($str == '0' || $str == '' || intval($str))
            return false;
        json_decode($str);
        return (json_last_error() == JSON_ERROR_NONE);
    }

    public static function pagination($obj){
        $obj->reset(FALSE);
        $total_items = $obj->count_all();
        unset($clone);
        return Pagination::factory(array('total_items' => $total_items));
    }

    public static function checkActionInRole($actionForCheck){
        $roles = Auth::instance()->get_user()->roles->find_all();
        foreach($roles as $role){
            $action = ORM::factory('Action', ['name' => $actionForCheck]);
            if($role->has('actions', $action)){
                return true;
            }
        }
        return false;
    }

    public static function EscapeSphinxQL($string){
        $from = ['-', '=', ':', '@'];
        $to   = ['\\-', '\\=', '\\:', '\\@'];
        return str_replace ( $from, $to, $string );
    }

    public static function MultiSphinxQL($string){
        $from = ['/', '.', '_', '?', '&'];
        $to   = [' ', ' ', ' ', ' ', ' '];
        $string = str_replace ( $from, $to, $string );
        $string = Helper::removeTwoCharsWords($string);
        
        return $string;
    }

    public static function removeTwoCharsWords($string){
        $tmp_string = explode(' ', preg_replace('#[^0-9A-Za-z]+#', ' ', stripslashes($string)));
        foreach($tmp_string as $t){
            if(strlen($t) <= 2){
                $string = preg_replace('#\b'.preg_quote($t,'#').'\b#', '', $string);
            }
        }
        return preg_replace('#\s+#',' ', $string); // fix multiple spacebar
    }

    public static function wrapWithWildcardsAndOptimize($string)
    {
        if (' ' != substr($string, 0, 1)) {
            $string = '*' . $string;
        } else {
            $string = ltrim($string);
        }

        if (' ' != substr($string, -1)) {
            $string = $string . '*';
        } else {
            $string = rtrim($string);
        }
        
        return $string;
    }
    
    public static function time_elapsed_string($datetime, $full = false) {
        if ( $datetime instanceof DateTime )
        {
            $ago = $datetime;
        }
        elseif ( is_string($datetime) )
        {
            $ago = new DateTime($datetime);
        }
        else
        {
            throw new InvalidArgumentException('Invalid argument supplied');
        }
        $now = new DateTime();
//        date_sub($now, date_interval_create_from_date_string('1 hours'));
        $diff = $now->diff($ago);

        $diff->w = floor($diff->d / 7);
        $diff->d -= $diff->w * 7;

        $string = array(
            'y' => 'year',
            'm' => 'month',
            'w' => 'week',
            'd' => 'day',
            'h' => 'hour',
            'i' => 'minute',
            's' => 'second',
        );
        foreach ($string as $k => &$v) {
            if ($diff->$k) {
                $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
            } else {
                unset($string[$k]);
            }
        }

        if (!$full) $string = array_slice($string, 0, 1);
        return $string ? implode(', ', $string) . ' ago' : 'just now';
    }

    public static function recursive_array_search($needle,$haystack) {
        foreach($haystack as $key=>$value) {
            $current_key=$key;
            if($needle===$value OR (is_array($value) && Helper::recursive_array_search($needle,$value) !== false)) {
                return $current_key;
            }
        }
        return false;
    }

    /**
     * Returns server's uptime
     *
     * @return string|false
     */
    public static function uptime()
    {
        if ( PHP_OS == 'Linux' )
        {
            $uptime = @file_get_contents( '/proc/uptime');
            if ( false !== $uptime )
            {
                $uptime = explode(' ', $uptime);
                $uptime = $uptime[0];
                $days = explode('.', (($uptime % 31556926) / 86400));
                $hours = explode('.', ((($uptime % 31556926) % 86400) / 3600));
                $minutes = explode('.', (((($uptime % 31556926) % 86400) % 3600) / 60));
                $time = '.';
                if ($minutes > 0)
                {
                    $time = $minutes[0] . ' mins' . $time;
                }
                if ($minutes > 0 && ($hours > 0 || $days > 0))
                {
                    $time = ', ' . $time;
                }
                if ($hours > 0)
                {
                    $time = $hours[0] . ' hours' . $time;
                }
                if ($hours > 0 && $days > 0)
                {
                    $time = ', ' . $time;
                }
                if ($days > 0)
                {
                    $time = $days[0] . ' days' . $time;
                }
            }
            else
            {
                $time = false;
            }
        }
        else
        {
            $time = false;
        }

        return $time;
    }

    /**
     * Count rows in table estimated
     *
     * @param string $table
     * @return string
     * @throws InvalidArgumentException
     */
    public static function countRowsEstimated($table)
    {
        $db = Database::instance(Database::$default);
        $platform = strtolower(Helper::getCurrentDatabaseConfig('type'));

        if ( 'mysql' == $platform || 'mysqli' == $platform )
        {
            $rowsCount = DB::query(Database::SELECT, 'EXPLAIN SELECT COUNT(' . $db->quote_column('id') . ') FROM ' . $db->quote_table($table) . ' USE INDEX (PRIMARY)')
                ->execute($db)
                ->get('rows');

            $rowsCount = '~ ' . $rowsCount;
        }
        elseif ( 'postgresql' == $platform )
        {
            $rowsCount = DB::query(Database::SELECT, 'SELECT ' . $db->quote_column('reltuples') . ' FROM ' . $db->quote_table('pg_class') . ' WHERE ' . $db->quote_column('oid') . ' = ' . $db->quote($table) . '::regclass')
                ->execute($db)
                ->get('reltuples');

            $rowsCount = '~ ' . sprintf('%.2F', floatval($rowsCount));
        }
        else
        {
            throw new InvalidArgumentException('Unsupported database driver ' . $platform);
        }

        return $rowsCount;
    }

    public static function getCounter($table){
        $result = DB::select('id')
            ->from('counter')
            ->where('name', '=', $table)
            ->execute()
            ->as_array();
        return $result[0]['id'];
    }

    public static function updCounter($max_id, $table){
        DB::update('counter')
            ->set(['id' => $max_id])
            ->where('name', '=', $table)
            ->execute();
    }

    public static function getCurrentDatabaseConfig($key = null)
    {
        $db_config = Kohana::$config->load('database.' . Database::$default);
        
        if (null !== $key) {
            return Arr::get($db_config, $key);
        }
        
        return $db_config;
    }
    
    public static function getCurrentSphinx(){
        return Kohana::$config->load('init.sphinx');
    }
}